

function FailMode()
	if GetUserPref("UserPrefGameLevel") == "Ultimate" then
		return "FailImmediate"
	end
	if GetUserPref("UserPrefGameLevel") == "Pro" then
		return "FailImmediateContinue"
	end
	if GetUserPref("UserPrefGameLevel") == "Standard" then
		return "FailOff"
	end
	if GetUserPref("UserPrefGameLevel") == "Beginner" then
		return "FailOff"
	end
end


function scorecap(n) -- credit http://richard.warburton.it
	local left,num,right = string.match(n,'^([^%d]*%d)(%d*)(.-)$')
	return left..(num:reverse():gsub('(%d%d%d)','%1.'):reverse())..right
end

function StartGame()
	--if MEMCARDMAN:GetCardState(Player) == 'MemoryCardState_none' then

		if PROFILEMAN:GetNumLocalProfiles() >= 2 then
			return "ScreenSelectProfile"
		else
			return "ScreenProfileLoad"
		end
	--else
	--	return "ScreenSelectProfile"
	--end
end


function InitUserPrefs()
	if GetUserPref("UserPrefGameLevel") == nil then
		SetUserPref("UserPrefGameLevel", "Standard");
	end;
	
	if GetUserPrefB("UserPrefDetailedPrecision") == nil then
		SetUserPref("UserPrefDetailedPrecision", false);
	end;
	
	if GetUserPref("UserPrefJudgmentType") == nil then
		SetUserPref("UserPrefJudgmentType", "Normal");
	end;
	
	if GetUserPref("UserPrefScorePosition") == nil then
		SetUserPref("UserPrefScorePosition", "Off");
	end;
	
	if GetUserPrefB("UserPrefLite") == nil then
		SetUserPref("UserPrefLite", true);
	end;

	if GetUserPref("UserPrefFlashCombo") == nil then
		SetUserPref("UserPrefFlashCombo", "100");
	end;
		
end;


function SetPrefBranch()
		if GetUserPref("UserPrefSetPreferences") == "Yes" then
			return "ScreenTitleMenu"
		else
			return "ScreenPrefPrompt"
		end
end



function PrevSong() if GAMESTATE:GetCurrentGame():GetName() == "dance" then return "MenuUp" else return "MenuLeft" end; end;
function NextSong() if GAMESTATE:GetCurrentGame():GetName() == "dance" then return "MenuDown" else return "MenuRight" end ;end;
function PrevDiff() if GAMESTATE:GetCurrentGame():GetName() == "dance" then return "MenuLeft" else return "MenuUp" end; end;
function NextDiff() if GAMESTATE:GetCurrentGame():GetName() == "dance" then return "MenuRight" else return "MenuDown" end; end;

--foi uma merda pra entender isso, ento pra no esquecer eu vou comentar esse lixo.
function UserPrefGameLevel()
	local t = {
		Name = "UserPrefGameLevel";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = true;
		Choices = { "Beginner","Standard","Pro","Ultimate"};
		LoadSelections = function(self, list, pn)
			if ReadPrefFromFile("UserPrefGameLevel") == nil then
				list[2] = true;
				WritePrefToFile("UserPrefGameLevel","Standard");

			else
				if GetUserPref("UserPrefGameLevel") == "Beginner" then
					list[1] = true;
				end

				if GetUserPref("UserPrefGameLevel") == "Standard" then
					list[2] = true;
				end

				if GetUserPref("UserPrefGameLevel") == "Pro" then
					list[3] = true;
				end			
				
				if GetUserPref("UserPrefGameLevel") == "Ultimate" then
					list[4] = true;
				end	

			end;
		end;
		SaveSelections = function(self, list, pn)
			local val;
				-- ao escolher uma opo, a string da escolha   devidamente salva na preferncia
				if list[1] then
					val = "Beginner"
				end

				if list[2] then
					val = "Standard"
				end

				if list[3] then
					val = "Pro"
				end
				
				if list[4] then
					val = "Ultimate"
				end
				
			WritePrefToFile("UserPrefGameLevel",val);
		end;
	};
	setmetatable( t, t );
	return t;
end






function UserPrefLite()
	local t = {
		Name = "UserPrefLite";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = true;
		Choices = { "Low", "High"};
		LoadSelections = function(self, list, pn)
			if ReadPrefFromFile("UserPrefLite") == nil then
				list[2] = true;
				WritePrefToFile("UserPrefLite",true);
			else
				if GetUserPrefB("UserPrefLite") == true then
					list[2] = true;
				end

				if GetUserPrefB("UserPrefLite") == false then
					list[1] = true;
				end

			end;
		end;
		SaveSelections = function(self, list, pn)
			local val;
				-- ao escolher uma opo, a string da escolha   devidamente salva na preferncia
				if list[1] then
					val = false
				end

				if list[2] then
					val = true
				end
				
			WritePrefToFile("UserPrefLite",val);
		end;
	};
	setmetatable( t, t );
	return t;
end




function UserPrefFlashCombo()
	local t = {
		Name = "UserPrefFlashCombo";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = true;
		Choices = { "Off", "50", "100"};
		LoadSelections = function(self, list, pn)
			if ReadPrefFromFile("UserPrefFlashCombo") == nil then
				list[3] = true;
				WritePrefToFile("UserPrefFlashCombo","100");
			else
				if GetUserPref("UserPrefFlashCombo") == "100" then
					list[3] = true;
				end

				if GetUserPref("UserPrefFlashCombo") == "50" then
					list[2] = true;
				end

				if GetUserPref("UserPrefFlashCombo") == "Off" then
					list[1] = true;
				end

			end;
		end;
		SaveSelections = function(self, list, pn)
			local val;
				-- no entiendo nada pero ya kedo XD
				if list[1] then
					val = "Off"
				end

				if list[2] then
					val = "50"
				end

				if list[3] then
					val = "100"
				end
				
			WritePrefToFile("UserPrefFlashCombo",val);
		end;
	};
	setmetatable( t, t );
	return t;
end






function UserPrefDetailedPrecision()
	local t = {
		-- parmetros auto-explicativos
		Name = "UserPrefDetailedPrecision";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = true;
		
		-- escolhas em strings
		Choices = { "Normal","Detailed" };
		LoadSelections = function(self, list, pn)
			if ReadPrefFromFile("UserPrefDetailedPrecision") == nil then
				list[1] = true;
				WritePrefToFile("UserPrefDetailedPrecision",false);

			else
				if GetUserPrefB("UserPrefDetailedPrecision") == false then
					list[1] = true;
				end

				if GetUserPrefB("UserPrefDetailedPrecision") == true then
					list[2] = true;
				end			


			end;
		end;

		SaveSelections = function(self, list, pn)
			local val;
				-- ao escolher uma opo, a string da escolha   devidamente salva na preferncia
				if list[1] then
					val = false
				end

				if list[2] then
					val = true
				end

			-- cria a merda do arquivo
			WritePrefToFile("UserPrefDetailedPrecision",val);
		end;
	};

	-- faz umas merdas que no entendo, pra funcionar
	setmetatable( t, t );
	return t;
end






function UserPrefJudgmentType()
	local t = {
		-- parmetros auto-explicativos
		Name = "UserPrefJudgmentType";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = true;
		
		-- escolhas em strings
		Choices = { "Normal","Deviation","Fiesta","NX"};
		LoadSelections = function(self, list, pn)
			if ReadPrefFromFile("UserPrefJudgmentType") == nil then
				list[1] = true;
				WritePrefToFile("UserPrefJudgmentType","Normal");
			else
			
				if GetUserPref("UserPrefJudgmentType") == "Normal" then
					list[1] = true;
				end

				if GetUserPref("UserPrefJudgmentType") == "Deviation" then
					list[2] = true;
				end		
				
				if GetUserPref("UserPrefJudgmentType") == "Fiesta" then
					list[3] = true;
				end		
				
				if GetUserPref("UserPrefJudgmentType") == "NX" then
					list[4] = true;
				end	


			end;
		end;

		SaveSelections = function(self, list, pn)
			local val;
				-- ao escolher uma opo, a string da escolha   devidamente salva na preferncia
				if list[1] then
					val = "Normal";
				end

				if list[2] then
					val = "Deviation";
				end
				
				if list[3] then
					val = "Fiesta";
				end
				
				if list[4] then
					val = "NX";
				end


			-- cria a merda do arquivo
			WritePrefToFile("UserPrefJudgmentType",val);
		end;
	};

	-- faz umas merdas que no entendo, pra funcionar
	setmetatable( t, t );
	return t;
end







function UserPrefScorePosition()
	local t = {
		-- parmetros auto-explicativos
		Name = "UserPrefScorePosition";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = true;
		
		-- escolhas em strings
		Choices = { "Top","Bottom","Off"};
		LoadSelections = function(self, list, pn)
			if ReadPrefFromFile("UserPrefScorePosition") == nil then
				list[3] = true;
				WritePrefToFile("UserPrefScorePosition","Off");
			else
			
				if GetUserPref("UserPrefScorePosition") == "Top" then
					list[1] = true;
				end

				if GetUserPref("UserPrefScorePosition") == "Bottom" then
					list[2] = true;
				end		
				
				if GetUserPref("UserPrefScorePosition") == "Off" then
					list[3] = true;
				end	

				
			end;
		end;

		SaveSelections = function(self, list, pn)
			local val;
				-- ao escolher uma opo, a string da escolha   devidamente salva na preferncia
				if list[1] then
					val = "Top";
				end

				if list[2] then
					val = "Bottom";
				end
				
				if list[3] then
					val = "Off";
				end

			-- cria a merda do arquivo
			WritePrefToFile("UserPrefScorePosition",val);
		end;
	};

	-- faz umas merdas que no entendo, pra funcionar
	setmetatable( t, t );
	return t;
end








function UserPrefSetPreferences()
	local t = {
		-- parmetros auto-explicativos
		Name = "UserPrefSetPreferences";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = true;
		
		-- escolhas em strings
		Choices = { "Yes", "No"};
		LoadSelections = function(self, list, pn)
			if ReadPrefFromFile("UserPrefSetPreferences") == nil then
				list[1] = true;
				WritePrefToFile("UserPrefSetPreferences","Yes");
			else
				if GetUserPref("UserPrefSetPreferences") == "Yes" then
					list[1] = true;
				end

				if GetUserPref("UserPrefSetPreferences") == "No" then
					list[2] = true;
				end		
				
				
			end;
		end;

		SaveSelections = function(self, list, pn)
			local val;
				-- ao escolher uma opo, a string da escolha   devidamente salva na preferncia
				if list[1] then
					val = "Yes";
				end

				if list[2] then
					val = "No";
				end


			-- cria a merda do arquivo
			WritePrefToFile("UserPrefSetPreferences",val);
		end;
	};

	-- faz umas merdas que no entendo, pra funcionar
	setmetatable( t, t );
	return t;
end







function Setup()

		PREFSMAN:SetPreference("TimingWindowSecondsW2",0.045);
		PREFSMAN:SetPreference("TimingWindowSecondsW3",0.09);
		PREFSMAN:SetPreference("TimingWindowSecondsW4",0.135);
		PREFSMAN:SetPreference("TimingWindowSecondsW5",0.18);
		PREFSMAN:SetPreference("TimingWindowSecondsMine",0.1);
		PREFSMAN:SetPreference("TimingWindowSecondsHold",0.25);

		if GetUserPref("UserPrefGameLevel") == "Beginner" then
		PREFSMAN:SetPreference("TimingWindowScale",1);
		SetGamePref("DefaultFail","FailOff");
		end

		if GetUserPref("UserPrefGameLevel") == "Standard" then
		PREFSMAN:SetPreference("TimingWindowScale",0.875);
		SetGamePref("DefaultFail","FailOff");
		end

		if GetUserPref("UserPrefGameLevel") == "Pro" then
		PREFSMAN:SetPreference("TimingWindowScale",0.6);
		SetGamePref("DefaultFail","FailImmediateContinue");
		end
		
		if GetUserPref("UserPrefGameLevel") == "Ultimate" then
		PREFSMAN:SetPreference("TimingWindowScale",0.425);
		SetGamePref("DefaultFail","FailImmediate");
		end

		
		SetUserPref("UserPrefScoringMode","");
		SetUserPref("UserPrefSpecialScoringMode","");
		
		local P1State = GAMESTATE:GetPlayerState(PLAYER_1);
		local P2State = GAMESTATE:GetPlayerState(PLAYER_2);
		local P1Options = P1State:GetPlayerOptionsString("ModsLevel_Preferred");
		local P2Options = P2State:GetPlayerOptionsString("ModsLevel_Preferred");
		P1State:SetPlayerOptions("ModsLevel_Preferred", P1Options..","..FailMode());
		P2State:SetPlayerOptions("ModsLevel_Preferred", P2Options..","..FailMode());
		--aca hacer magia
		PREFSMAN:SetPreference("ShowNativeLanguage",true);
		--PREFSMAN:SetPreference("CoinMode","CoinMode_Home");
		PREFSMAN:SetPreference("EditorNoteSkinP1","delta-note");
		PREFSMAN:SetPreference("EditorNoteSkinP2","delta-note");
		PREFSMAN:SetPreference("PercentageScoring",true);
		PREFSMAN:SetPreference("LifeDifficultyScale",0.4);
		PREFSMAN:SetPreference("ProgressiveLifebar",true);
		PREFSMAN:SetPreference("AllowW1","AllowW1_Never");	
		PREFSMAN:SetPreference("OnlyDedicatedMenuButtons",false);	
		PREFSMAN:SetPreference("Premium","Premium_DoubleFor1Credit");
		PREFSMAN:SetPreference("ShowDancingCharacters","ShowDancingCharacters_Off");
		PREFSMAN:SetPreference("ShowBanners",false);
	
	
end;


function DeltaWheel(self,offsetFromCenter,itemIndex,numItems)
	local x = offsetFromCenter * 310
	if offsetFromCenter >= 1 then 
		x = scale(offsetFromCenter,-1,1,-1,1) * 310 
	elseif offsetFromCenter <= -1 then 
		x = scale(offsetFromCenter,-1,1,-1,1) * 310 
	end 
	self:x( x ) 
	self:z((-clamp(math.abs(offsetFromCenter),0,0)*280)-math.abs(offsetFromCenter))
	self:rotationy( clamp( offsetFromCenter, 0,0) * 90) 
end

function GameplayNext()
	--si es un MT
	if GAMESTATE:IsCourseMode() == true then
		return "ScreenEvaluationCourse"
	else
		return "ScreenEvaluation"
	end
end


function SelectMusicOrCourse()
	if GAMESTATE:IsCourseMode() then
		return "ScreenSelectCourse"
	else
		return "ScreenSelectMusic"
	end
end

function ProfSaveNext()
	if GAMESTATE:IsEventMode() then
		return SelectMusicOrCourse()
	elseif STATSMAN:GetCurStageStats():AllFailed() then
		return "ScreenGameOver"
	elseif GAMESTATE:GetSmallestNumStagesLeftForAnyHumanPlayer() == 0 then
		return "ScreenGameOver"
	else
		return SelectMusicOrCourse()
	end
end

function AreStagePlayerModsForced()
	local bExtraStage = GAMESTATE:IsAnExtraStage()
	local bOni = GAMESTATE:GetPlayMode() == "PlayMode_Oni"
	return bExtraStage or bOni
end

function AreStageSongModsForced()
	local bExtraStage = GAMESTATE:IsAnExtraStage()
	local pm = GAMESTATE:GetPlayMode()
	local bOni = pm == "PlayMode_Oni"
	local bBattle = pm == "PlayMode_Battle"
	local bRave = pm == "PlayMode_Rave"
	return bExtraStage or bOni or bBattle or bRave
end
